const express = require('express');
const app = express();
const bodyParser = require('body-parser');
const request = require('superagent');
const apiKey = 'A1';

const buttonToStateMap = {
    "Revoke": "OFF",
    "Publish": "Published",
    "Update": "Updated",
    "Error": "Errored"
}

app.use(bodyParser.json());

app.get('/configuration', function (req, res) {
  res.send( {
    url: "http://localhost:3000/action",
    timeout: 15,
	initialstate: "OFF",
    states: [ 
        { 
            name: "OFF",
            buttons: [ "Publish" ]
        },
        { 
            name: "Published",
            type: "success",
            buttons: [ "Update", "Revoke" ]
        },
        { 
            name: "Updated",
            buttons: [ "Update", "Error", "Revoke" ]
        },
        { 
            name: "Errored",
            type: "error",
            buttons: [ "Update" ] 
        },
    ]
  })
});

app.post('/action', function (req, res) {
	console.log(req.body);
    const button = req.body.button;
    const url = req.body.subject.url;
    const customdata = req.body.customdata;
    const targetState = buttonToStateMap[button];
    request
		.put(url + '/customdata')
        .query( { 'api_key': apiKey })
        .send( [ { 
         "keyword": customdata,
         "value": targetState
        } ]).end( (err, success) => {
            if (err) {
                console.log("ERROR " + err);
            } 
        });
    res.send("ok");
});

app.listen(3000, function () {
  console.log('Example app listening on port 3000!')
});